/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.worlds.together.surfaceRules;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_5284;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_6686;
import org.betterx.worlds.together.chunkgenerator.InjectableSurfaceRules;
import org.betterx.worlds.together.surfaceRules.SurfaceRuleProvider;
import org.betterx.worlds.together.surfaceRules.SurfaceRuleRegistry;
import org.betterx.worlds.together.world.event.WorldBootstrap;

public class SurfaceRuleUtil {
    private static List<class_6686.class_6708> getRulesForBiome(class_2960 biomeID) {
        class_2378 registry = SurfaceRuleRegistry.BUILTIN_SURFACE_RULES;
        if (WorldBootstrap.getLastRegistryAccess() != null) {
            registry = WorldBootstrap.getLastRegistryAccess().method_30530(SurfaceRuleRegistry.SURFACE_RULES_REGISTRY);
        }
        return registry.method_10220().filter(a -> a != null && a.biomeID != null && a.biomeID.equals((Object)biomeID)).map(a -> a.ruleSource).toList();
    }

    private static List<class_6686.class_6708> getRulesForBiomes(List<class_1959> biomes) {
        class_2378 biomeRegistry = WorldBootstrap.getLastRegistryAccess().method_30530(class_2378.field_25114);
        List<class_2960> biomeIDs = biomes.stream().map(b -> biomeRegistry.method_10221(b)).filter(id -> id != null).toList();
        return biomeIDs.stream().map(biomeID -> SurfaceRuleUtil.getRulesForBiome(biomeID)).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedList::new));
    }

    private static class_6686.class_6708 mergeSurfaceRulesFromBiomes(class_6686.class_6708 org, class_1966 source) {
        return SurfaceRuleUtil.mergeSurfaceRules(org, SurfaceRuleUtil.getRulesForBiomes(source.method_28443().stream().map(h -> (class_1959)h.comp_349()).toList()));
    }

    private static class_6686.class_6708 mergeSurfaceRules(class_6686.class_6708 org, List<class_6686.class_6708> additionalRules) {
        if (additionalRules == null || additionalRules.isEmpty()) {
            return org;
        }
        if (org instanceof class_6686.class_6710) {
            class_6686.class_6710 sequenceRule = (class_6686.class_6710)org;
            List existingSequence = sequenceRule.comp_209();
            if ((additionalRules = additionalRules.stream().filter(r -> existingSequence.indexOf(r) < 0).collect(Collectors.toList())).size() == 0) {
                return org;
            }
            additionalRules.addAll(existingSequence);
        } else if (!additionalRules.contains(org)) {
            additionalRules.add(org);
        }
        return new class_6686.class_6710(additionalRules);
    }

    public static void injectSurfaceRules(class_5284 noiseSettings, class_1966 loadedBiomeSource) {
        class_5284 class_52842 = noiseSettings;
        if (class_52842 instanceof SurfaceRuleProvider) {
            SurfaceRuleProvider srp = (SurfaceRuleProvider)class_52842;
            class_6686.class_6708 originalRules = noiseSettings.comp_478();
            srp.bclib_overwrite(SurfaceRuleUtil.mergeSurfaceRulesFromBiomes(originalRules, loadedBiomeSource));
        }
    }

    public static void injectSurfaceRulesToAllDimensions(class_5285 settings) {
        for (Map.Entry entry : settings.method_28609().method_29722()) {
            class_5321 key = (class_5321)entry.getKey();
            class_5363 stem = (class_5363)entry.getValue();
            class_2794 class_27942 = stem.method_29571();
            if (!(class_27942 instanceof InjectableSurfaceRules)) continue;
            InjectableSurfaceRules generator = (InjectableSurfaceRules)class_27942;
            generator.injectSurfaceRules((class_5321<class_5363>)key);
        }
    }
}

